/*
 * @(#)ModelInterface.java Aug 18, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol;

import java.io.Serializable;
import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The model interface defines the model object. *
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.4 2004-03-26
 * @since 1.3
 */
public interface ModelInterface extends Serializable
{
	/**
	 * construct a model on a simulator
	 * 
	 * @param simulator is the simulator
	 * @throws SimRuntimeException on model failure
	 * @throws RemoteException on network failure
	 */
	void constructModel(SimulatorInterface simulator)
			throws SimRuntimeException, RemoteException;
}