/*
 * @(#) Renderable3DInterface.java May 10, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.animation.D3;

/**
 * Renderable3DInterface, an interface for 3d renderables <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 10.05.2004 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public interface Renderable3DInterface
{
	/**
	 * Static (non dynamic) objects that describe the world or landscape,
	 * possibly containing other static or animated objects.
	 */
	int STATIC_OBJECT = 0;

	/** Simulated objects are objects that move, rotate or change shape */
	int DYNAMIC_OBJECT = 1;

	/**
	 * Update the representation of the model
	 */
	void update();

	/**
	 * Get the type.
	 * 
	 * @return Type of renderable
	 */
	int getType();
}