/*
 * @(#) ContextUtil.java Oct 26, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.context;

import javax.naming.Context;
import javax.naming.InitialContext;

import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * ContextUtil provides utility methods to resolve and bind objects to the
 * context based on their experiment dependent path. <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 26.10.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 */
public final class ContextUtil extends
		nl.tudelft.simulation.naming.context.ContextUtil
{
	/**
	 * constructs a new ContextUtil
	 */
	private ContextUtil()
	{
		super();
	}

	/**
	 * creates a subContext in the context
	 * 
	 * @param simulator the simulator
	 * @param subContext the context to create
	 */
	public static void createSubContext(final SimulatorInterface simulator,
			final String subContext)
	{
		ContextUtil.createSubContext(simulator, null, subContext);
	}

	/**
	 * creates a subContext in the context
	 * 
	 * @param simulator the simulator
	 * @param context the context
	 * @param subContext the context to create
	 */
	public static void createSubContext(final SimulatorInterface simulator,
			final String context, final String subContext)
	{
		try
		{
			String name = simulator.getReplication().getRunControl()
					.getTreatment().getExperiment().getRun()
					+ "/treatment("
					+ simulator.getReplication().getRunControl().getTreatment()
							.getNumber()
					+ ")/replication("
					+ simulator.getReplication().getNumber() + ")";
			if (context != null)
			{
				name = name + context;
			}
			((Context) new InitialContext().lookup(name))
					.createSubcontext(subContext);
		} catch (Exception exception)
		{
			Logger.warning(ContextUtil.class, "createSubContext", exception);
		}
	}

	/**
	 * binds an object to the context
	 * 
	 * @param simulator the simulator
	 * @param object the object
	 */
	public static void bindToContext(final SimulatorInterface simulator,
			final Object object)
	{
		ContextUtil.bindToContext(simulator, null, object);
	}

	/**
	 * binds an object to the context
	 * 
	 * @param simulator the simulator
	 * @param context the context in this tree
	 * @param object the object
	 */
	public static void bindToContext(final SimulatorInterface simulator,
			final String context, final Object object)
	{
		try
		{
			String name = simulator.getReplication().getRunControl()
					.getTreatment().getExperiment().getRun()
					+ "/treatment("
					+ simulator.getReplication().getRunControl().getTreatment()
							.getNumber()
					+ ")/replication("
					+ simulator.getReplication().getNumber() + ")";
			if (context != null)
			{
				name = name + context;
			}
			((Context) new InitialContext().lookup(name)).bind(object
					.getClass().getName().substring(
							object.getClass().getName().lastIndexOf("."))
					+ "#" + object.toString(), object);
		} catch (Exception exception)
		{
			Logger.warning(ContextUtil.class, "bindToContext", exception);
		}
	}
}