/*
 * @(#)Replication.java Aug 18, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.experiment;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import nl.tudelft.simulation.jstats.streams.StreamInterface;


/**
 * The replication of a runcontrol.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.7 Apr 7, 2004
 * @since 1.4
 */
public class Replication implements Serializable
{

	/**
	 * streams used in the replication
	 * 
	 * @uml.property name="streams"
	 */
	private Map streams = new HashMap();

	/**
	 * description the description of the replication
	 * 
	 * @uml.property name="description"
	 */
	private String description = "rep_no_description";

	/**
	 * runControl reflects the RunControl
	 * 
	 * @uml.property name="runControl"
	 */
	private RunControl runControl;

	/**
	 * the number of the replication
	 * 
	 * @uml.property name="number"
	 */
	private int number = 0;


	/**
	 * constructs a new Replication
	 * 
	 * @param runControl reflects the RunControl
	 * @param number the number
	 */
	public Replication(final RunControl runControl, final int number)
	{
		super();
		this.runControl = runControl;
		this.number = number;
	}

	/**
	 * gets the description of this replication
	 * 
	 * @return String the description of this replication
	 * 
	 * @uml.property name="description"
	 */
	public String getDescription()
	{
		return this.description;
	}

	/**
	 * returns the number of this replication
	 * 
	 * @return int the number
	 * 
	 * @uml.property name="number"
	 */
	public int getNumber()
	{
		return this.number;
	}

	/**
	 * returns the parental RunControl
	 * 
	 * @return RunControl the runcontrol
	 * 
	 * @uml.property name="runControl"
	 */
	public RunControl getRunControl()
	{
		return this.runControl;
	}

	/**
	 * returns the streams
	 * 
	 * @return Map the streams of this replication
	 * 
	 * @uml.property name="streams"
	 */
	public Map getStreams()
	{
		return this.streams;
	}


	/**
	 * returns a specific stream
	 * 
	 * @param name the name of the stream
	 * @return StreamInterface the stream
	 */
	public StreamInterface getStream(final String name)
	{
		return (StreamInterface) this.streams.get(name);
	}

	/**
	 * resets the RunControl
	 */
	public synchronized void reset()
	{
		for (Iterator i = this.streams.values().iterator(); i.hasNext();)
		{
			StreamInterface stream = (StreamInterface) i.next();
			stream.reset();
		}
	}

	/**
	 * Sets the description of this replication
	 * 
	 * @param description the description of this replication
	 * 
	 * @uml.property name="description"
	 */
	public void setDescription(final String description)
	{
		this.description = description;
	}

	/**
	 * sets the stream for this replication
	 * 
	 * @param streams the map of stream,name tuples
	 * 
	 * @uml.property name="streams"
	 */
	public void setStreams(final Map streams)
	{
		this.streams = streams;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		String result = super.toString() + " ; " + this.getDescription()
				+ " ; streams=[";
		Collection values = this.streams.values();
		for (Iterator i = values.iterator(); i.hasNext();)
		{
			result = result + i.next().toString() + " ; ";
		}
		result = result.substring(0, result.length() - 2) + "]";
		return result;
	}
}