/*
 * @(#)Treatment.java Aug 18, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.experiment;

import java.util.Calendar;
import java.util.Properties;

import nl.tudelft.simulation.event.EventProducer;

/**
 * The treatment is comprises the specification of input data, the runControl
 * and the specification of output data. (Sol:1982, Oeren&Zeigler:1979) <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class Treatment extends EventProducer
{

	/**
	 * experiment reflects the experiment
	 * 
	 * @uml.property name="experiment"
	 */
	private Experiment experiment;

	/**
	 * runControl reflects the runControl
	 * 
	 * @uml.property name="runControl"
	 */
	private RunControl runControl;

	/**
	 * startTime of the treatment
	 * 
	 * @uml.property name="startTime"
	 */
	private long startTime = 0L;

	/**
	 * timeUnit reflects the timeUnit
	 * 
	 * @uml.property name="timeUnit"
	 */
	private TimeUnitInterface timeUnit = TimeUnitInterface.UNIT;

	/**
	 * the number of the treatment
	 * 
	 * @uml.property name="number"
	 */
	private int number = 0;

	/**
	 * the properties of this treatment
	 * 
	 * @uml.property name="properties"
	 */
	private Properties properties = new Properties();


	/**
	 * contructs a Treatment
	 * 
	 * @param experiment reflects the experiment
	 * @param number the number of this treatment
	 */
	public Treatment(final Experiment experiment, final int number)
	{
		super();
		this.experiment = experiment;
		this.number = number;
	}

	/**
	 * returns the number of this replication
	 * 
	 * @return int the number
	 * 
	 * @uml.property name="number"
	 */
	public int getNumber()
	{
		return this.number;
	}

	/**
	 * returns the experiment
	 * 
	 * @return Experiment the experiment
	 * 
	 * @uml.property name="experiment"
	 */
	public Experiment getExperiment()
	{
		return this.experiment;
	}

	/**
	 * returns the properties for this treatment
	 * 
	 * @return Properties
	 * 
	 * @uml.property name="properties"
	 */
	public Properties getProperties()
	{
		return this.properties;
	}

	/**
	 * returns the RunControl
	 * 
	 * @return RunControl the runControl
	 * 
	 * @uml.property name="runControl"
	 */
	public RunControl getRunControl()
	{
		return this.runControl;
	}

	/**
	 * returns the startTime
	 * 
	 * @return long the startTime
	 * 
	 * @uml.property name="startTime"
	 */
	public long getStartTime()
	{
		return this.startTime;
	}

	/**
	 * returns the timeUnit
	 * 
	 * @return timeUnit
	 * 
	 * @uml.property name="timeUnit"
	 */
	public TimeUnitInterface getTimeUnit()
	{
		return this.timeUnit;
	}

	/**
	 * sets the properties
	 * 
	 * @param properties the properties
	 * 
	 * @uml.property name="properties"
	 */
	public void setProperties(final Properties properties)
	{
		this.properties = properties;
	}

	/**
	 * sets the RunControl
	 * 
	 * @param runControl the control.
	 * 
	 * @uml.property name="runControl"
	 */
	public void setRunControl(final RunControl runControl)
	{
		this.runControl = runControl;
	}

	/**
	 * sets the startTime of the treatment
	 * 
	 * @param startTime reflects the startTime
	 * 
	 * @uml.property name="startTime"
	 */
	public void setStartTime(final long startTime)
	{
		this.startTime = startTime;
	}

	/**
	 * sets the timeUnit of the treatment
	 * 
	 * @param timeUnit is the timeunit
	 * 
	 * @uml.property name="timeUnit"
	 */
	public void setTimeUnit(final TimeUnitInterface timeUnit)
	{
		this.timeUnit = timeUnit;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(this.getStartTime());

		String result = "[" + super.toString() + " ; "
				+ calendar.getTime().toString() + " ; " + this.getTimeUnit()
				+ " ; runcontrol=" + this.getRunControl().toString() + "";
		return result;
	}
}