/*
 * @(#)ResourceRequestorInterface.java Feb 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms;

import java.rmi.RemoteException;

/**
 * This interface provides a callback method to the resource. Whenever resource
 * is available this method is invoked on the requestor.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.2 2004-03-26
 * @since 1.0
 */
public interface ResourceRequestorInterface
{
	/**
	 * receive the requested resource
	 * 
	 * @param requestedCapacity reflects the amount requested
	 * @param resource the requested resource
	 * @throws RemoteException on network failure
	 */
	void receiveRequestedResource(final double requestedCapacity,
			final Resource resource) throws RemoteException;
}