/*
 * @(#) SimEventInterface.java Feb 24, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.devs;

import java.io.Serializable;

import nl.tudelft.simulation.dsol.SimRuntimeException;

/**
 * A SimEventInterface embodies the envolope in the scheduled method invocation
 * information is stored.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.11 2004-03-26
 * @since 1.0
 */
public interface SimEventInterface extends Serializable, Comparable
{
	/** MAX_PRIORITY is a constant reflecting the maximum priority */
	short MAX_PRIORITY = 10;

	/** NORMAL_PRIORITY is a constant reflecting the normal priority */
	short NORMAL_PRIORITY = 5;

	/** MIN_PRIORITY is a constant reflecting the minimal priority */
	short MIN_PRIORITY = 1;

	/**
	 * executes the simEvent.
	 * 
	 * @throws SimRuntimeException on execution failure
	 */
	void execute() throws SimRuntimeException;

	/**
	 * @return the scheduled execution time of a simulation event.
	 */
	double getAbsoluteExecutionTime();

	/**
	 * @return The priority of a simulation event. The priorities are programmed
	 *         according to the Java thread priority. Use 10 (MAX_PRIORITY), -9, .. ,
	 *         5 (NORMAL_PRIORITY), 1(MIN_PRIORITY)
	 */
	short getPriority();

	/**
	 * sets the id of an event. Whenever a simulation event is added or removed
	 * from an eventlist, the list might want to set an ID for comparison. This
	 * is the only way to ensure a comparison on equal priority and execution
	 * time.
	 * 
	 * @return retuns the id
	 */
	long getID();

	/**
	 * sets the id of an event. Whenever a simulation event is added or removed
	 * from an eventlist, the list might want to set an ID for comparison. This
	 * is the only way to ensure a comparison on equal priority and execution
	 * time.
	 * 
	 * @param id the id
	 */
	void setID(long id);
}