/*
 * @(#)StationInterface.java Feb 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.flow;

import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;

/**
 * The exit station on which statistics are updated and entities destroyed. <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class Departure extends Station
{
	/**
	 * Constructor for Departure.
	 * 
	 * @param simulator on which is scheduled
	 */
	public Departure(final DEVSSimulatorInterface simulator)
	{
		super(simulator);
	}

	/**
	 * @see StationInterface#receiveObject(java.lang.Object)
	 */
	public synchronized void receiveObject(final Object object)
	{
		this.fireEvent(StationInterface.RECEIVE_EVENT, object);
		this.fireEvent(StationInterface.RELEASE_EVENT, object);
	}
}