/*
 * @(#)Release.java Feb 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.flow;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.formalisms.Resource;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The release station releases a given quantity of a claimed resource. <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class Release extends Station
{
	/** resource refers to the resource released */
	private Resource resource;

	/** amount defines the amount to be released */
	private double amount = 1.0;

	/**
	 * Constructor for Release.
	 * 
	 * @param simulator on which is scheduled
	 * @param resource which is released
	 */
	public Release(final DEVSSimulatorInterface simulator,
			final Resource resource)
	{
		this(simulator, resource, 1.0);
	}

	/**
	 * Constructor for Release.
	 * 
	 * @param simulator on which is scheduled
	 * @param resource which is released
	 * @param amount of resource which is released
	 */
	public Release(final DEVSSimulatorInterface simulator,
			final Resource resource, final double amount)
	{
		super(simulator);
		this.resource = resource;
		this.amount = amount;
	}

	/**
	 * @see StationInterface#receiveObject(Object)
	 */
	public synchronized void receiveObject(final Object object)
			throws RemoteException
	{
		super.receiveObject(object);
		try
		{
			this.resource.releaseCapacity(this.amount);
			this.releaseObject(object);
		} catch (Exception exception)
		{
			Logger.warning(this, "receiveObject", exception);
		}
	}
}