/*
 * @(#)Station.java Feb 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.flow;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.event.EventProducer;

/**
 * A station is an object which can accept other objects. *
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.2 2004-03-26
 * @since 1.0
 */
public abstract class Station extends EventProducer implements StationInterface
{
	/** simulator is the simulator on which behavior is scheduled */
	protected DEVSSimulatorInterface simulator;

	/**
	 * destination refers to the next station in the process-model chain
	 * 
	 * @uml.property name="destination"
	 */
	protected StationInterface destination;


	/**
	 * constructs a new Station.
	 * 
	 * @param simulator is the simulator on which behavior is scheduled
	 */
	public Station(final DEVSSimulatorInterface simulator)
	{
		super();
		this.simulator = simulator;
	}

	/**
	 * @see StationInterface#receiveObject(Object)
	 */
	public void receiveObject(final Object object) throws RemoteException
	{
		this.fireEvent(StationInterface.RECEIVE_EVENT, 1.0, this.simulator
				.getSimulatorTime());
	}

	/**
	 * @see StationInterface#setDestination(StationInterface)
	 * 
	 * @uml.property name="destination"
	 */
	public void setDestination(final StationInterface destination)
	{
		this.destination = destination;
	}

	/**
	 * releases an object
	 * 
	 * @param object is the entity
	 * @throws RemoteException on network failure
	 */
	protected synchronized void releaseObject(final Object object)
			throws RemoteException
	{
		this.fireEvent(StationInterface.RELEASE_EVENT, 0.0, this.simulator
				.getSimulatorTime());
		if (this.destination != null)
		{
			this.destination.receiveObject(object);
		}
	}

	/**
	 * Returns the destination.
	 * 
	 * @return the destination station
	 * 
	 * @uml.property name="destination"
	 */
	public StationInterface getDestination()
	{
		return this.destination;
	}

}