/*
 * @(#)StationInterface.java Feb 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.flow;

import java.rmi.RemoteException;

import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;

/**
 * A station is an object which accepts other objects and is linked to a
 * destination.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.5 2004-03-26
 * @since 1.0
 */
public interface StationInterface extends EventProducerInterface
{
	/** RECEIVE_EVENT is fired whenever an entity enters the station */
	EventType RECEIVE_EVENT = new EventType("RECEIVE_EVENT");

	/** RECEIVE_EVENT is fired whenever an entity leaves the station */
	EventType RELEASE_EVENT = new EventType("RELEASE_EVENT");

	/**
	 * Method getDestination.
	 * 
	 * @return StationInterface is the destination of this station
	 * @throws RemoteException on network failure
	 */
	StationInterface getDestination() throws RemoteException;

	/**
	 * receives an object is invoked whenever an entity arrives
	 * 
	 * @param object is the entity
	 * @throws RemoteException on network failure
	 */
	void receiveObject(final Object object) throws RemoteException;

	/**
	 * sets the destination of this object
	 * 
	 * @param destination defines the next station in the model
	 * @throws RemoteException on network failure
	 */
	void setDestination(final StationInterface destination)
			throws RemoteException;
}