/*
 * @(#) Utilization.java Dec 8, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.flow.statistics;

import java.rmi.RemoteException;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import nl.tudelft.simulation.dsol.context.ContextUtil;
import nl.tudelft.simulation.dsol.formalisms.flow.StationInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.jstats.statistics.Persistent;
import nl.tudelft.simulation.logger.Logger;

/**
 * A Utilization <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Dec 8, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Utilization extends Persistent
{
	/** initialzed the tally */
	private boolean initialized = false;

	/** simulator */
	private SimulatorInterface simulator = null;

	/**
	 * constructs a new Utilization
	 * 
	 * @param description the description of this utilization
	 * @param simulator the simulator
	 * @param target the target
	 * @throws RemoteException on network failure
	 */
	public Utilization(final String description,
			final SimulatorInterface simulator, final StationInterface target)
			throws RemoteException
	{
		super(description);
		this.simulator = simulator;
		target.addListener(this, StationInterface.RECEIVE_EVENT, false);
		target.addListener(this, StationInterface.RELEASE_EVENT, false);
		this.simulator
				.addListener(this, SimulatorInterface.WARMUP_EVENT, false);
		this.simulator.addListener(this,
				SimulatorInterface.END_OF_REPLICATION_EVENT, false);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		try
		{
			if (event.getSource().equals(this.simulator))
			{
				if (event.getType().equals(SimulatorInterface.WARMUP_EVENT))
				{
					this.initialized = true;
					this.simulator.removeListener(this,
							SimulatorInterface.WARMUP_EVENT);
					super.initialize();
					return;
				}
				if (event.getType().equals(
						SimulatorInterface.END_OF_REPLICATION_EVENT))
				{
					this.simulator.removeListener(this,
							SimulatorInterface.END_OF_REPLICATION_EVENT);
					this.endOfReplication();
					return;
				}
			} else if (this.initialized)
			{
				super.notify(event);
			}
		} catch (RemoteException remoteException)
		{
			Logger.warning(this, "notify", remoteException);
		}
	}

	/**
	 * endOfReplication is invoked to store the final results
	 */
	protected void endOfReplication()
	{
		try
		{
			String[] parts = nl.tudelft.simulation.naming.context.ContextUtil
					.resolveKey(this).split("/");
			String key = "";
			for (int i = 0; i < parts.length; i++)
			{
				if (i != parts.length - 2)
				{
					key = key + parts[i] + "/";
				}
			}
			key = key.substring(0, key.length() - 1);
			nl.tudelft.simulation.jstats.statistics.Tally tally = null;
			try
			{
				tally = (nl.tudelft.simulation.jstats.statistics.Tally) new InitialContext()
						.lookup(key);
			} catch (NamingException exception)
			{
				tally = new nl.tudelft.simulation.jstats.statistics.Tally(
						this.description);
				new InitialContext().bind(key, tally);
				tally.initialize();
			}
			tally.notify(new Event(null, this, new Double(this.sampleMean)));
		} catch (Exception exception)
		{
			Logger.warning(this, "endOfReplication", exception);
		}
	}
}