/*
 * @(#) PROCESSINVOKESPECIAL.java Jan 8, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.process;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.Interpreter;
import nl.tudelft.simulation.language.concurrent.Monitor;

/**
 * PROCESSINVOKESPECIAL <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Jan 8, 2004 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a> <br>
 *         <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class PROCESSINVOKESPECIAL
		extends
		nl.tudelft.simulation.dsol.interpreter.operations.reflection.INVOKESPECIAL
{
	/**
	 * constructs a new PROCESSINVOKESPECIAL
	 * 
	 * @param dataInput the dataInput
	 * @throws IOException on IOfailure
	 */
	public PROCESSINVOKESPECIAL(final DataInput dataInput) throws IOException
	{
		super(dataInput);
	}

	/**
	 * executes the operation and returns a new Frame
	 * 
	 * @param frame the original frame
	 * @param objectRef the object on which to invoke the method
	 * @param arguments the arguments with which to invoke the method
	 * @param method the method to invoke
	 * @throws Exception on invocation exception
	 * @return a new frame
	 */
	public Frame execute(final Frame frame, final Object objectRef,
			final Method method, final Object[] arguments) throws Exception
	{
		if (Modifier.isNative(method.getModifiers())
				|| !Process.class.isAssignableFrom(objectRef.getClass()))
		{
			return super.execute(frame, objectRef, method, arguments);
		}
		if (Modifier.isSynchronized(method.getModifiers()))
		{
			Monitor.lock(objectRef);
		}
		return Interpreter.createFrame(objectRef, method, arguments);
	}
}