/*
 * @(#) InterpreterFactory.java Jan 14, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.process;

import java.io.DataInput;
import java.io.IOException;

import nl.tudelft.simulation.dsol.interpreter.Operation;
import nl.tudelft.simulation.dsol.interpreter.operations.InterpreterFactory;
import nl.tudelft.simulation.dsol.interpreter.operations.reflection.INVOKEINTERFACE;
import nl.tudelft.simulation.dsol.interpreter.operations.reflection.INVOKESPECIAL;
import nl.tudelft.simulation.dsol.interpreter.operations.reflection.INVOKESTATIC;
import nl.tudelft.simulation.dsol.interpreter.operations.reflection.INVOKEVIRTUAL;

/**
 * A InterpreterFactory <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Jan 14, 2004 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class ProcessFactory extends InterpreterFactory
{
	/**
	 * constructs a new InterpreterFactory
	 */
	public ProcessFactory()
	{
		super();
	}

	/**
	 * reads a sequence of bytes and returns the appropriate bytecode
	 * operations.
	 * 
	 * @param operand the operatand (short value)
	 * @param dataInput the dataInput to read from
	 * @param startBytePostion the position in the current block of bytecode.
	 * @return the assemnbly Operation
	 * @throws IOException on IO exception
	 */
	public Operation readOperation(final int operand,
			final DataInput dataInput, final int startBytePostion)
			throws IOException
	{
		switch (operand)
		{
			case INVOKEINTERFACE.OP :
				return new PROCESSINVOKEINTERFACE(dataInput);
			case INVOKESPECIAL.OP :
				return new PROCESSINVOKESPECIAL(dataInput);
			case INVOKESTATIC.OP :
				return new PROCESSINVOKESTATIC(dataInput);
			case INVOKEVIRTUAL.OP :
				return new PROCESSINVOKEVIRTUAL(dataInput);
			default :
				return super
						.readOperation(operand, dataInput, startBytePostion);
		}
	}
}