/*
 * @(#)AnimatorInterface.java Aug 18, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.simulators;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The reference implementation of the DEVDESS simulator.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.9 2004-03-18
 * @since 1.0
 */
public class DEVDESSSimulator extends DEVSSimulator implements
		DEVDESSSimulatorInterface
{

	/**
	 * timeStep represents the DESS timeStep
	 * 
	 * @uml.property name="timeStep"
	 */
	protected double timeStep = DEFAULT_TIME_STEP;

	/**
	 * @see nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface
	 *      #getTimeStep()
	 * 
	 * @uml.property name="timeStep"
	 */
	public double getTimeStep()
	{
		return this.timeStep;
	}

	/**
	 * @see nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface
	 *      #setTimeStep(double)
	 * 
	 * @uml.property name="timeStep"
	 */
	public void setTimeStep(final double timeStep)
	{
		synchronized (super.semaphore)
		{
			if (timeStep < 0)
			{
				throw new IllegalArgumentException("timeStep < 0 ?");
			}
			this.timeStep = timeStep;
			this.fireEvent(TIME_STEP_CHANGED_EVENT, timeStep);
			Logger.finer(this, "setTimeStep", timeStep + "");
		}
	}

	/**
	 * @see nl.tudelft.simulation.dsol.simulators.DEVSSimulator#run()
	 */
	public void run()
	{
		while (this.isRunning()
				&& !this.eventList.isEmpty()
				&& this.simulatorTime <= this.replication.getRunControl()
						.getRunLength())
		{
			synchronized (super.semaphore)
			{
				double runUntil = this.simulatorTime + this.timeStep;
				while (!this.eventList.isEmpty()
						&& this.running
						&& runUntil >= (this.eventList.first())
								.getAbsoluteExecutionTime())
				{
					SimEventInterface event = this.eventList.removeFirst();
					this.simulatorTime = event.getAbsoluteExecutionTime();
					this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT,
							this.simulatorTime, this.simulatorTime);
					try
					{
						event.execute();
					} catch (Exception exception)
					{
						Logger.severe(this, "run", exception);
					}
				}
				if (this.running)
				{
					this.simulatorTime = runUntil;
				}
				this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT,
						this.simulatorTime, this.simulatorTime);
			}
		}
	}
}