/*
 * @(#) BoxAndWhiskerChart.java Oct 19, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.statistics.charts;

import nl.tudelft.simulation.dsol.context.ContextUtil;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The BoxAndWhiskerPlot extends the BoxAndWhiskerPlot and links this it to the
 * dsol framework <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.08.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class BoxAndWhiskerChart extends
		nl.tudelft.simulation.jstats.charts.boxAndWhisker.BoxAndWhiskerChart
{

	/**
	 * constructs a new BoxAndWhiskerChart
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 */
	public BoxAndWhiskerChart(final SimulatorInterface simulator,
			final String title)
	{
		super(title);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return super.getChart().getTitle().getText();
	}
}