/*
 * @(#) Histogram.java Oct 19, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.statistics.charts;

import nl.tudelft.simulation.dsol.context.ContextUtil;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The Histogram extends the Histogram and links this it to the dsol framework
 * <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.08.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Histogram extends
		nl.tudelft.simulation.jstats.charts.histogram.Histogram
{

	/**
	 * constructs a new Histogram
	 * 
	 * @param simulator the simulator
	 * @param title the title of the plot
	 * @param domain the domain of the plot
	 * @param range the range of the plot
	 * @param numberofBins the number of bins in this plot
	 */
	public Histogram(final SimulatorInterface simulator, final String title,
			final double[] domain, final double[] range, final int numberofBins)
	{
		super(title, domain, range, numberofBins);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * constructs a new Histogram
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 * @param domain the domain
	 * @param numberofBins the number of bins
	 */
	public Histogram(final SimulatorInterface simulator, final String title,
			final double[] domain, final int numberofBins)
	{
		super(title, domain, numberofBins);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return super.getChart().getTitle().getText();
	}
}