/*
 * @(#) XYChart.java Oct 19, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.statistics.charts;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.context.ContextUtil;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The XYPlot extends the XYPlot and links this it to the dsol framework <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.08.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class XYChart extends nl.tudelft.simulation.jstats.charts.xy.XYChart
{
	/**
	 * constructs a new XYChart
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 * @throws RemoteException on network failure
	 */
	public XYChart(final SimulatorInterface simulator, final String title)
			throws RemoteException
	{
		this(simulator, title, new double[]{0,
				simulator.getReplication().getRunControl().getRunLength()});
	}

	/**
	 * constructs a new XYChart
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 * @param axisType the axisType to use.
	 * @throws RemoteException on network failure
	 */
	public XYChart(final SimulatorInterface simulator, final String title,
			final short axisType) throws RemoteException
	{
		this(simulator, title, new double[]{0,
				simulator.getReplication().getRunControl().getRunLength()},
				axisType);
	}

	/**
	 * constructs a new XYChart
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 * @param domain the domain
	 */
	public XYChart(final SimulatorInterface simulator, final String title,
			final double[] domain)
	{
		super(title, domain);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * constructs a new XYChart
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 * @param domain the domain
	 * @param axisType the axisType to use.
	 */
	public XYChart(final SimulatorInterface simulator, final String title,
			final double[] domain, final short axisType)
	{
		super(title, domain, axisType);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * constructs a new XYChart
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 * @param domain the domain
	 * @param range the range
	 */
	public XYChart(final SimulatorInterface simulator, final String title,
			final double[] domain, final double[] range)
	{
		super(title, domain, range);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * constructs a new XYChart
	 * 
	 * @param simulator the simulator
	 * @param title the title
	 * @param domain the domain
	 * @param range the range
	 * @param axisType the XYChart.axisType
	 */
	public XYChart(final SimulatorInterface simulator, final String title,
			final double[] domain, final double[] range, final short axisType)
	{
		super(title, domain, range, axisType);
		ContextUtil.bindToContext(simulator, this);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return super.getChart().getTitle().getText();
	}
}