/*
 * @(#) DEVSSimulatorTest.java Sep 4, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.simulators;

import java.rmi.RemoteException;

import junit.framework.Assert;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.simulators.DESSSimulator;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;

/**
 * The DESSSSimulatorTest test the DEVS Simulator <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class DESSSimulatorTest extends SimulatorTest
{
	/**
	 * constructs a new DEVSSimulatorTest
	 */
	public DESSSimulatorTest()
	{
		super(new DESSSimulator());
	}

	/**
	 * @see nl.tudelft.simulation.dsol.simulators.SimulatorTest#test()
	 */
	public void test()
	{
		super.test();
		Experiment experiment = TestExperiment.createExperiment();
		experiment.setModel(new TestModel(experiment));
		try
		{
			DESSSimulatorInterface dessSimulator = (DESSSimulatorInterface) super.simulator;
			dessSimulator.setTimeStep(new Double(experiment
					.getProperty("TIMESTEP")).doubleValue());
			experiment.setSimulator(dessSimulator);
			experiment.start();
		} catch (RemoteException e)
		{
			Assert.fail(e.getMessage());
		}
	}

	/**
	 * Executes a DESSSimulatorTest
	 * 
	 * @param args the arguments given on the command line
	 */
	public static void main(final String[] args)
	{
		new DESSSimulatorTest().test();
	}
}