/*
 * @(#) DEVSSimulatorTest.java Sep 4, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.simulators;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulator;

/**
 * The DEVSSimulatorTest test the DEVS Simulator <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class DEVSSimulatorTest extends SimulatorTest
{
	/**
	 * constructs a new DEVSSimulatorTest
	 */
	public DEVSSimulatorTest()
	{
		super(new DEVSSimulator());
	}

	/**
	 * @see nl.tudelft.simulation.dsol.simulators.SimulatorTest#test()
	 */
	public void test()
	{
		super.test();
		Experiment experiment = TestExperiment.createExperiment();
		experiment.setModel(new DEVSTestModel(experiment));

		experiment.setSimulator(new DEVSSimulator());
		experiment.start();

	}

	/**
	 * The main method
	 * 
	 * @param args command-line input
	 */
	public static void main(final String[] args)
	{
		new DEVSSimulatorTest().test();
	}
}