/*
 * @(#) DEVSTestModel.java Sep 5, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.simulators;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulator;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The DEVSSimulatorTestmodel specifies the model <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class DEVSTestModel extends TestModel
{
	/** simulator refers to the target */
	protected DEVSSimulatorInterface simulator;

	/**
	 * constructs a new DEVSTestModel
	 * 
	 * @param experiment the experiment which is triggered on the model
	 */
	public DEVSTestModel(final Experiment experiment)
	{
		super(experiment);
	}

	/**
	 * @see nl.tudelft.simulation.dsol.ModelInterface
	 *      #constructModel(SimulatorInterface)
	 */
	public void constructModel(final SimulatorInterface simulator)
			throws RemoteException
	{
		super.constructModel(simulator);
		this.simulator = (DEVSSimulator) simulator;
		for (int i = 0; i < 100; i++)
		{
			try
			{
				this.simulator.scheduleEvent(new SimEvent(Math.random() * i,
						this, this, "run", null));
			} catch (RemoteException exception)
			{
				exception.printStackTrace();
			} catch (SimRuntimeException exception)
			{
				exception.printStackTrace();
			}
		}
	}

	/**
	 * the method which is scheduled
	 */
	public void run()
	{
		//Testing method
	}
}