/*
 * @(#) SimulatorTest.java Sep 4, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.simulators;

import java.rmi.RemoteException;

import junit.framework.Assert;
import junit.framework.TestCase;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The SimulatorTest test the basic behavior of the simulator <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class SimulatorTest extends TestCase
{
	/** TEST_METHOD refers to the name of the test method */
	public static final String TEST_METHOD = "test";

	/** simulator is the target to test */
	protected SimulatorInterface simulator;

	/**
	 * constructs a new SimulatorTest
	 * 
	 * @param target is the simulator which to test
	 */
	public SimulatorTest(final SimulatorInterface target)
	{
		this(TEST_METHOD, target);
	}

	/**
	 * constructs a new SimulatorTest
	 * 
	 * @param arg0 the name of the test method
	 * @param target is the simulator which to test
	 */
	public SimulatorTest(final String arg0, final SimulatorInterface target)
	{
		super(arg0);
		this.simulator = target;
	}

	/**
	 * test the DEVS Simulator
	 */
	public void test()
	{
		try
		{
			this.simulator.start();
			Assert.fail("Simulator not initialized");
		} catch (Exception exception)
		{
			Assert.assertTrue(exception.getClass().equals(
					SimRuntimeException.class));
		}
		try
		{
			this.simulator.stop();
			Assert.fail("Simulator not running");
		} catch (Exception exception)
		{
			Assert.assertTrue(exception.getClass().equals(
					SimRuntimeException.class));
		}
		try
		{
			this.simulator.step();
			Assert.fail("Simulator not initialized");
		} catch (Exception exception)
		{
			Assert.assertTrue(exception.getClass().equals(
					SimRuntimeException.class));
		}
		try
		{
			Assert.assertFalse(this.simulator.isRunning());
		} catch (Exception exception)
		{
			Assert.assertTrue(exception.getClass()
					.equals(RemoteException.class));
		}
		try
		{
			Assert.assertNull(this.simulator.getReplication());
			Assert.assertTrue(new Double(this.simulator.getSimulatorTime())
					.isNaN());
			this.simulator.initialize(null);
		} catch (Exception exception)
		{
			//initialize(null) should throw an exception
			Assert.assertTrue(exception instanceof IllegalArgumentException);
		}
	}
}