/*
 * @(#) TestModel.java Sep 4, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.simulators;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;

/**
 * The TestModel <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class TestModel implements ModelInterface, EventListenerInterface
{
	/** experiment refers to the experiment which is fired to the simulator */
	private Experiment experiment = null;

	/** the startTime */
	private long startTime = 0L;

	/**
	 * constructs a new TestModel
	 * 
	 * @param experiment refers to the experiment
	 */
	public TestModel(final Experiment experiment)
	{
		super();
		this.experiment = experiment;
	}

	/**
	 * @see nl.tudelft.simulation.dsol.ModelInterface
	 *      #constructModel(SimulatorInterface)
	 */
	public void constructModel(final SimulatorInterface simulator)
			throws RemoteException
	{
		simulator
				.addListener(this, SimulatorInterface.END_OF_REPLICATION_EVENT);
		simulator.addListener(this, SimulatorInterface.START_REPLICATION_EVENT);
		simulator.addListener(this, SimulatorInterface.START_EVENT);
		simulator.addListener(this, SimulatorInterface.STOP_EVENT);
		simulator.addListener(this, SimulatorInterface.STEP_EVENT);
		simulator.addListener(this, SimulatorInterface.TIME_CHANGED_EVENT);
		this.experiment.addListener(this, Experiment.END_OF_EXPERIMENT_EVENT);
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		if (event.getType().equals(SimulatorInterface.START_EVENT))
		{
			this.startTime = System.currentTimeMillis();
			System.out.println("started @ " + this.startTime);
		}
		if (event.getType().equals(SimulatorInterface.STOP_EVENT))
		{
			long runLength = System.currentTimeMillis() - this.startTime;
			try
			{
				System.out.println("runlength="
						+ runLength
						+ " time="
						+ ((SimulatorInterface) event.getSource())
								.getSimulatorTime());
			} catch (RemoteException e)
			{
				e.printStackTrace();
			}
		}
	}
}