/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.animation.D2;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Hashtable;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.javel.gisbeans.map.MapInterface;
import nl.javel.gisbeans.map.mapfile.MapFileXMLParser;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.CartesianPoint;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.context.ContextUtil;

public class GisRenderable2D
implements Renderable2DInterface,
LocatableInterface {
    protected MapInterface map = null;
    protected BufferedImage image = null;
    protected Rectangle2D extent = new Rectangle2D.Double();
    protected Dimension screenSize = new Dimension();
    protected DirectedPoint location = null;
    protected Bounds bounds = null;

    public GisRenderable2D(SimulatorInterface simulator, URL mapFile) {
        try {
            this.map = MapFileXMLParser.parseMapFile((URL)mapFile);
            this.location = new DirectedPoint((Point3d)new CartesianPoint(this.extent.getCenterX(), this.extent.getCenterY(), -4.9E-324));
            this.bounds = new BoundingBox(this.extent.getWidth(), this.extent.getHeight(), 0.0);
            ((Hashtable)simulator.getReplication().getRunControl().getTreatment().getProperties()).put("animationPanel.extent", this.map.getExtent());
            nl.tudelft.simulation.dsol.context.ContextUtil.bindToContext(simulator, "/animation/2D", this);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"<init>", (Throwable)exception);
        }
    }

    public void paint(Graphics2D graphics, Rectangle2D extent, Dimension screen, ImageObserver observer) {
        try {
            if (extent.equals(this.extent) && screen.equals(this.screenSize)) {
                graphics.drawImage((Image)this.image, 0, 0, null);
                return;
            }
            this.map.setExtent((Rectangle2D)extent.clone());
            this.map.getImage().setSize(screen);
            this.cacheImage();
            this.paint(graphics, extent, screen, observer);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"paint", (Throwable)exception);
        }
    }

    public LocatableInterface getSource() {
        return this;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public DirectedPoint getLocation() {
        return this.location;
    }

    private void cacheImage() throws Exception {
        this.image = new BufferedImage((int)this.map.getImage().getSize().getWidth(), (int)this.map.getImage().getSize().getHeight(), 6);
        Graphics2D bg = this.image.createGraphics();
        this.map.drawMap(bg);
        bg.dispose();
        this.screenSize = (Dimension)this.map.getImage().getSize().clone();
        this.extent = this.map.getExtent();
        this.location = new DirectedPoint((Point3d)new CartesianPoint(this.extent.getCenterX(), this.extent.getCenterY(), -4.9E-324));
        this.bounds = new BoundingBox(this.extent.getWidth(), this.extent.getHeight(), 0.0);
    }

    public void destroy() {
        try {
            ContextUtil.unbindFromContext((Object)this);
        }
        catch (Throwable throwable) {
            Logger.warning((Object)this, (String)"finalize", (Throwable)throwable);
        }
    }

    public boolean contains(Point2D pointWorldCoordinates, Rectangle2D extent, Dimension screen) {
        return false;
    }
}

