/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.animation.D2;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.context.ContextUtil;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d2.Shape;
import nl.tudelft.simulation.language.d3.BoundsUtil;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;

public abstract class Renderable2D
implements Renderable2DInterface {
    protected boolean rotate = true;
    protected boolean flip = false;
    protected boolean scale = true;
    protected boolean translate = true;
    protected SimulatorInterface simulator = null;
    protected LocatableInterface source = null;

    public Renderable2D(LocatableInterface source, SimulatorInterface simulator) {
        this.source = source;
        this.simulator = simulator;
        ContextUtil.bindToContext(simulator, "/animation/2D", this);
    }

    public boolean isFlip() {
        return this.flip;
    }

    public void setFlip(boolean flip) {
        this.flip = flip;
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    public boolean isScale() {
        return this.scale;
    }

    public void setScale(boolean scale) {
        this.scale = scale;
    }

    public LocatableInterface getSource() {
        return this.source;
    }

    public boolean isTranslate() {
        return this.translate;
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    public synchronized void paint(Graphics2D graphics, Rectangle2D extent, Dimension screen, ImageObserver observer) {
        try {
            DirectedPoint location = this.source.getLocation();
            Rectangle2D rectangle = BoundsUtil.getIntersect((DirectedPoint)this.source.getLocation(), (Bounds)this.source.getBounds(), (double)location.z);
            if (!Shape.overlaps((Rectangle2D)extent, (Rectangle2D)rectangle) && this.translate) {
                return;
            }
            Point2D screenCoordinates = Renderable2DInterface.Util.getScreenCoordinates(this.source.getLocation().to2D(), extent, screen);
            if (this.translate) {
                graphics.translate(screenCoordinates.getX(), screenCoordinates.getY());
            }
            double scale = Renderable2DInterface.Util.getScale(extent, screen);
            if (this.scale) {
                graphics.scale(1.0 / scale, 1.0 / scale);
            }
            double angle = -location.getRotZ();
            if (this.flip && angle > Math.PI) {
                angle -= Math.PI;
            }
            if (this.rotate && angle != 0.0) {
                graphics.rotate(angle);
            }
            this.paint(graphics, observer);
            if (this.rotate && angle != 0.0) {
                graphics.rotate(-angle);
            }
            if (this.scale) {
                graphics.scale(scale, scale);
            }
            if (this.translate) {
                graphics.translate(-screenCoordinates.getX(), -screenCoordinates.getY());
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"paint", (Throwable)exception);
        }
    }

    public boolean contains(Point2D pointWorldCoordinates, Rectangle2D extent, Dimension screen) {
        try {
            Rectangle2D intersect = BoundsUtil.getIntersect((DirectedPoint)this.source.getLocation(), (Bounds)this.source.getBounds(), (double)this.source.getLocation().z);
            if (intersect == null) {
                throw new NullPointerException("empty intersect!: location.z is not in bounds. This is probably due to a modeling error. See the javadoc off LocatableInterface.");
            }
            return intersect.contains(pointWorldCoordinates);
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"contains", (Throwable)exception);
            return false;
        }
    }

    public void destroy() {
        try {
            nl.tudelft.simulation.naming.context.ContextUtil.unbindFromContext((Object)this);
        }
        catch (Throwable throwable) {
            Logger.warning((Object)this, (String)"finalize", (Throwable)throwable);
        }
    }

    public String toString() {
        if (this != this.source) {
            return super.toString() + "-OF-" + this.source.toString();
        }
        return super.toString() + "-OF-" + super.toString();
    }

    public abstract void paint(Graphics2D var1, ImageObserver var2) throws RemoteException;
}

