/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.animation.D2;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;

public interface Renderable2DInterface {
    public void paint(Graphics2D var1, Rectangle2D var2, Dimension var3, ImageObserver var4);

    public LocatableInterface getSource();

    public boolean contains(Point2D var1, Rectangle2D var2, Dimension var3);

    public void destroy() throws RemoteException;

    public static class Util {
        protected Util() {
        }

        public static double getScale(Rectangle2D extent, Dimension screen) {
            if (screen.getHeight() <= 0.0 || screen.getWidth() <= 0.0) {
                return Double.NaN;
            }
            return extent.getWidth() / screen.getWidth();
        }

        public static Rectangle2D computeVisibleExtent(Rectangle2D extent, Dimension screen) {
            if (extent == null || screen == null || screen.getHeight() <= 0.0 || screen.getWidth() <= 0.0) {
                return null;
            }
            double xScale = extent.getWidth() / screen.getWidth();
            double yScale = extent.getHeight() / screen.getHeight();
            Rectangle2D result = (Rectangle2D)extent.clone();
            if (xScale >= yScale) {
                result.setRect(result.getCenterX() - 0.5 * yScale * screen.getWidth(), result.getY(), yScale * screen.getWidth(), result.getHeight());
            } else {
                result.setRect(result.getX(), result.getCenterY() - 0.5 * xScale * screen.getHeight(), result.getWidth(), xScale * screen.getHeight());
            }
            return result;
        }

        public static Point2D getScreenCoordinates(Point2D worldCoordinates, Rectangle2D extent, Dimension screen) {
            double scale = 1.0 / Util.getScale(extent, screen);
            double x = (worldCoordinates.getX() - extent.getMinX()) * scale;
            double y = screen.getHeight() - (worldCoordinates.getY() - extent.getMinY()) * scale;
            return new Point2D.Double(x, y);
        }

        public static Point2D getWorldCoordinates(Point2D screenCoordinates, Rectangle2D extent, Dimension screen) {
            double scale = Util.getScale(extent, screen);
            double x = screenCoordinates.getX() * scale + extent.getMinX();
            double y = (screen.getHeight() - screenCoordinates.getY()) * scale + extent.getMinY();
            return new Point2D.Double(x, y);
        }
    }
}

