/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.experiment;

import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.experiment.RunControl;
import nl.tudelft.simulation.dsol.experiment.Treatment;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;

public class Experiment
extends EventProducer
implements EventListenerInterface,
Serializable {
    public static final EventType END_OF_EXPERIMENT_EVENT = new EventType("END_OF_EXPERIMENT_EVENT");
    public static final EventType MODEL_CHANGED_EVENT = new EventType("MODEL_CHANGED_EVENT");
    public static final EventType SIMULATOR_CHANGED_EVENT = new EventType("SIMULATOR_CHANGED_EVENT");
    public static final String EXPERIMENT_NAME = "EXPERIMENT_NAME";
    public static final String EXPERIMENT_ANALYST = "EXPERIMENT_ANALYST";
    private Treatment[] treatments = null;
    private Properties properties = new Properties();
    private int treatment = 0;
    private SimulatorInterface simulator;
    private ModelInterface model;
    private String run;
    private URL url = null;

    public synchronized void setSimulator(SimulatorInterface simulator) {
        this.simulator = simulator;
        this.fireEvent(SIMULATOR_CHANGED_EVENT, simulator);
    }

    public SimulatorInterface getSimulator() {
        return this.simulator;
    }

    public String getRun() {
        return this.run;
    }

    public synchronized void start() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.run = DateFormat.getDateTimeInstance().format(calendar.getTime());
        try {
            new InitialContext().createSubcontext(this.run);
        }
        catch (NamingException exception) {
            Logger.warning((Object)this, (String)"start", (Throwable)exception);
        }
        this.treatment = 0;
        this.notify((EventInterface)new Event(RunControl.END_OF_RUN_EVENT, (Object)this, null));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        ((Hashtable)this.properties).put(key, value);
    }

    public ModelInterface getModel() {
        return this.model;
    }

    public URL getUrl() {
        return this.url;
    }

    public void notify(EventInterface event) {
        try {
            Context context = (Context)new InitialContext().lookup(this.run);
            if (event.getType().equals((Object)RunControl.END_OF_RUN_EVENT)) {
                if (this.treatment < this.treatments.length) {
                    context.createSubcontext("treatment(" + this.treatment + ")");
                    this.treatments[this.treatment].getRunControl().addListener(this, RunControl.END_OF_RUN_EVENT, (short)-1, false);
                    ++this.treatment;
                    this.treatments[this.treatment - 1].getRunControl().start(this.simulator);
                } else {
                    this.fireEvent((EventInterface)new Event(END_OF_EXPERIMENT_EVENT, (Object)this, null));
                }
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"notify", (Throwable)exception);
        }
    }

    public synchronized void reset() {
        this.treatment = 0;
        for (int i = 0; i < this.treatments.length; ++i) {
            this.treatments[i].getRunControl().reset();
        }
        try {
            this.setSimulator((SimulatorInterface)this.simulator.getClass().newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void setModel(ModelInterface model) {
        this.model = model;
        this.fireEvent(MODEL_CHANGED_EVENT, model);
    }

    public Treatment[] getTreatments() {
        return this.treatments;
    }

    public void setTreatments(Treatment[] treatments) {
        this.treatments = treatments;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String toString() {
        String result = "[" + super.toString() + " ; " + this.getProperty("dsol.experiment.projectTitle") + " ; " + this.getProperty("dsol.experiment.analystName") + " ; treatments=";
        for (int i = 0; i < this.treatments.length; ++i) {
            result = result + this.treatments[i].toString() + " ; ";
        }
        result = result.substring(0, result.length() - 2) + "]";
        return result;
    }
}

