/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.ResourceRequestorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;

public class Resource
extends EventProducer {
    public static final EventType UTILIZATION_EVENT = new EventType("UTILIZATION_EVENT");
    public static final EventType RESOURCE_REQUESTED_QUEUE_LENGTH = new EventType("RESOURCE_REQUESTED_QUEUE_LENGTH");
    protected double capacity;
    protected double claimedCapacity = 0.0;
    private List requests = Collections.synchronizedList(new ArrayList());
    protected DEVSSimulatorInterface simulator;
    protected String description = "resource";

    public Resource(DEVSSimulatorInterface simulator, String description, double capacity) {
        this.description = description;
        this.simulator = simulator;
        this.capacity = capacity;
    }

    public Resource(DEVSSimulatorInterface simulator, double capacity) {
        this(simulator, "resource", capacity);
    }

    public double getCapacity() {
        return this.capacity;
    }

    private synchronized void alterClaimedCapacity(double amount) throws RemoteException {
        this.claimedCapacity += amount;
        this.fireEvent(UTILIZATION_EVENT, this.claimedCapacity, this.simulator.getSimulatorTime());
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestCapacity(double amount, ResourceRequestorInterface requestor) throws RemoteException, SimRuntimeException {
        if (amount < 0.0) {
            throw new SimRuntimeException("requested capacity on resource cannot <0.0");
        }
        if (this.claimedCapacity + amount <= this.capacity) {
            this.alterClaimedCapacity(amount);
            this.simulator.scheduleEvent(0.0, (Object)this, requestor, "receiveRequestedResource", new Object[]{new Double(amount), this});
        } else {
            List list = this.requests;
            synchronized (list) {
                this.requests.add(new Request(requestor, amount));
            }
            this.fireEvent(RESOURCE_REQUESTED_QUEUE_LENGTH, this.requests.size(), this.simulator.getSimulatorTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCapacity(double amount) throws RemoteException {
        if (amount < 0.0) {
            throw new IllegalArgumentException("released capacity on resource cannot <0.0");
        }
        this.alterClaimedCapacity(-amount);
        List list = this.requests;
        synchronized (list) {
            Iterator i = this.requests.iterator();
            while (i.hasNext()) {
                Request request = (Request)i.next();
                if (!(this.capacity - this.claimedCapacity >= request.getAmount())) continue;
                this.alterClaimedCapacity(amount);
                request.getRequestor().receiveRequestedResource(request.getAmount(), this);
                List list2 = this.requests;
                synchronized (list2) {
                    this.requests.remove(request);
                }
                this.fireEvent(RESOURCE_REQUESTED_QUEUE_LENGTH, this.requests.size(), this.simulator.getSimulatorTime());
                if (this.capacity - this.claimedCapacity >= 0.0) {
                    this.releaseCapacity(0.0);
                }
                return;
            }
        }
    }

    public String toString() {
        return this.description;
    }

    public class Request {
        private ResourceRequestorInterface requestor;
        private double amount;

        public Request(ResourceRequestorInterface requestor, double amount) {
            this.requestor = requestor;
            this.amount = amount;
        }

        public double getAmount() {
            return this.amount;
        }

        public ResourceRequestorInterface getRequestor() {
            return this.requestor;
        }
    }
}

