/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms.devs;

import java.io.Serializable;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;

public abstract class AbstractSimEvent
implements SimEventInterface,
Comparable,
Serializable {
    protected double absoluteExecutionTime = Double.NaN;
    protected short priority = (short)5;
    protected long id = 0L;

    public AbstractSimEvent(double executionTime) {
        this(executionTime, 5);
    }

    public AbstractSimEvent(double executionTime, short priority) {
        this.absoluteExecutionTime = executionTime;
        if (priority < 0 || priority > 11) {
            throw new IllegalArgumentException("priority must be between [1..10]");
        }
        this.priority = priority;
    }

    public int compareTo(Object object) {
        SimEventInterface simEvent = (SimEventInterface)object;
        if (this.absoluteExecutionTime < simEvent.getAbsoluteExecutionTime()) {
            return -1;
        }
        if (this.absoluteExecutionTime > simEvent.getAbsoluteExecutionTime()) {
            return 1;
        }
        if (this.priority < simEvent.getPriority()) {
            return 1;
        }
        if (this.priority > simEvent.getPriority()) {
            return -1;
        }
        if (this.id < simEvent.getID()) {
            return -1;
        }
        if (this.id > simEvent.getID()) {
            return 1;
        }
        return 0;
    }

    public abstract void execute() throws SimRuntimeException;

    public double getAbsoluteExecutionTime() {
        return this.absoluteExecutionTime;
    }

    public short getPriority() {
        return this.priority;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }
}

