/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms.devs;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.devs.AbstractSimEvent;
import nl.tudelft.simulation.language.reflection.ClassUtil;

public class SimEvent
extends AbstractSimEvent {
    protected Object source = null;
    protected Object target = null;
    protected String method = null;
    protected Object[] args = null;

    public SimEvent(double executionTime, Object source, Object target, String method, Object[] args) {
        this(executionTime, 5, source, target, method, args);
    }

    public SimEvent(double executionTime, short priority, Object source, Object target, String method, Object[] args) {
        super(executionTime, priority);
        if (source == null || target == null || method == null) {
            throw new IllegalArgumentException("either source, target or method==null");
        }
        this.source = source;
        this.target = target;
        this.method = method;
        this.args = args;
    }

    public synchronized void execute() throws SimRuntimeException {
        try {
            if (this.method.equals("<init>")) {
                Constructor constructor = ClassUtil.resolveConstructor((Class)((Class)this.target), (Object[])this.args);
                if (!ClassUtil.isVisible((Constructor)constructor, this.source.getClass())) {
                    throw new SimRuntimeException(this.method + " is not accessible for " + this.source);
                }
                ((AccessibleObject)constructor).setAccessible(true);
                constructor.newInstance(this.args);
            } else {
                Method method = ClassUtil.resolveMethod((Object)this.target, (String)this.method, (Object[])this.args);
                if (!ClassUtil.isVisible((Method)method, this.source.getClass())) {
                    throw new SimRuntimeException(this.method + " is not accessible for " + this.source);
                }
                ((AccessibleObject)method).setAccessible(true);
                method.invoke(this.target, this.args);
            }
        }
        catch (Exception exception) {
            throw new SimRuntimeException(exception);
        }
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        return "SimEvent[time=" + this.absoluteExecutionTime + "; priority=" + this.priority + "; source=" + this.source + "; target=" + this.target + "; method=" + this.method + "; args=" + this.args + "]";
    }
}

