/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms.flow;

import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.flow.Station;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.SerializableConstructor;
import nl.tudelft.simulation.logger.Logger;

public class Generator
extends Station {
    public static final EventType CREATE_EVENT = new EventType("CREATE_EVENT");
    protected Object[] constructorArguments;
    protected DistContinuous interval;
    protected DistContinuous startTime;
    private DistDiscrete batchSize;
    protected SerializableConstructor constructor;
    private long maxNumber = -1L;
    private long number = 0L;
    protected SimEvent nextEvent = null;

    public Generator(DEVSSimulatorInterface simulator, Class myClass, Object[] constructorArguments) throws SimRuntimeException {
        super(simulator);
        try {
            Constructor constructor = ClassUtil.resolveConstructor((Class)myClass, (Object[])constructorArguments);
            this.constructor = new SerializableConstructor(constructor);
        }
        catch (Exception exception) {
            throw new SimRuntimeException(exception);
        }
        this.constructorArguments = constructorArguments;
    }

    public void generate() throws SimRuntimeException {
        this.generate(this.constructorArguments);
    }

    public synchronized void generate(Object[] constructorArguments) throws SimRuntimeException {
        try {
            if (this.maxNumber == -1L || this.number < this.maxNumber) {
                ++this.number;
                int i = 0;
                while ((long)i < this.batchSize.draw()) {
                    Object object = this.constructor.deSerialize().newInstance(constructorArguments);
                    Logger.finest((Object)this, (String)"generate", (String)("created " + this.number + "th instance of " + this.constructor.deSerialize().getDeclaringClass()));
                    this.fireEvent(CREATE_EVENT, 1);
                    this.releaseObject(object);
                    ++i;
                }
                this.nextEvent = new SimEvent(this.simulator.getSimulatorTime() + this.interval.draw(), this, this, "generate", null);
                this.simulator.scheduleEvent(this.nextEvent);
            }
        }
        catch (Exception exception) {
            throw new SimRuntimeException(exception);
        }
    }

    public void receiveObject(Object object) {
        try {
            this.releaseObject(object);
        }
        catch (RemoteException remoteException) {
            Logger.warning((Object)this, (String)"receiveObject", (Throwable)remoteException);
        }
    }

    public DistDiscrete getBatchSize() {
        return this.batchSize;
    }

    public DistContinuous getInterval() {
        return this.interval;
    }

    public long getMaxNumber() {
        return this.maxNumber;
    }

    public void setBatchSize(DistDiscrete batchSize) {
        this.batchSize = batchSize;
    }

    public void setInterval(DistContinuous interval) {
        this.interval = interval;
    }

    public void setMaxNumber(long maxNumber) {
        this.maxNumber = maxNumber;
    }

    public DistContinuous getStartTime() {
        return this.startTime;
    }

    public synchronized void setStartTime(DistContinuous startTime) {
        this.startTime = startTime;
        try {
            this.nextEvent = new SimEvent(startTime.draw(), this, this, "generate", null);
            this.simulator.scheduleEvent(this.nextEvent);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"setStartTime", (Throwable)exception);
        }
    }
}

