/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms.process;

import java.lang.reflect.AccessibleObject;
import java.rmi.RemoteException;
import java.util.Stack;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.Interpreter;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;

public abstract class Process {
    private Stack frameStack = new Stack();
    protected DEVSSimulatorInterface simulator = null;

    public Process(DEVSSimulatorInterface simulator) {
        this.simulator = simulator;
        try {
            this.frameStack.push(Interpreter.createFrame((Object)this, (AccessibleObject)ClassUtil.resolveMethod((Object)this, (String)"process", null), null));
            double simulatorTime = this.simulator.getSimulatorTime();
            if (Double.isNaN(simulatorTime)) {
                simulatorTime = 0.0;
            }
            SimEvent simEvent = new SimEvent(simulatorTime, this, this, "resume", null);
            this.simulator.scheduleEvent(simEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.severe((Object)this, (String)"<init>", (Throwable)exception);
        }
    }

    public abstract void process() throws SimRuntimeException, RemoteException;

    protected void hold(double duration) throws SimRuntimeException, RemoteException {
        this.simulator.scheduleEvent(new SimEvent(this.simulator.getSimulatorTime() + duration, this, this, "resume", null));
        this.suspend();
    }

    public synchronized void resume() {
        if (this.frameStack.isEmpty()) {
            return;
        }
        try {
            ((Frame)this.frameStack.peek()).setPaused(false);
            Object result = Interpreter.interpret((Stack)this.frameStack);
            if (result instanceof Stack) {
                this.frameStack = (Stack)result;
            }
        }
        catch (InterpreterException exception) {
            Logger.warning((Object)this, (String)"resume", (Throwable)exception);
        }
    }

    protected void suspend() throws SimRuntimeException {
        throw new SimRuntimeException("suspend should be interpreted. One may not invoke this method directly");
    }
}

