/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.simulators;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.eventlists.EventListInterface;
import nl.tudelft.simulation.dsol.eventlists.RedBlackTree;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.experiment.TimeUnit;
import nl.tudelft.simulation.dsol.experiment.TimeUnitInterface;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.Simulator;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.logger.Logger;

public class DEVSSimulator
extends Simulator
implements DEVSSimulatorInterface {
    protected EventListInterface eventList = new RedBlackTree();

    public boolean cancelEvent(SimEventInterface event) {
        return this.eventList.remove(event);
    }

    public EventListInterface getEventList() {
        return this.eventList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Replication replication) throws RemoteException, SimRuntimeException {
        Object object = this.semaphore;
        synchronized (object) {
            super.initialize(replication);
            this.eventList.clear();
            this.replication.getRunControl().getTreatment().getExperiment().getModel().constructModel(this);
            this.scheduleEvent(new SimEvent(this.getReplication().getRunControl().getRunLength(), 0, this, this, "stop", null));
            Object[] args = new Object[]{new Event(SimulatorInterface.WARMUP_EVENT, (Object)this, null)};
            this.scheduleEvent(new SimEvent(this.getReplication().getRunControl().getWarmupPeriod(), 11, this, this, "fireEvent", args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleEvent(SimEventInterface event) throws SimRuntimeException {
        Object object = this.semaphore;
        synchronized (object) {
            if (event.getAbsoluteExecutionTime() < this.simulatorTime || new Double(event.getAbsoluteExecutionTime()).isNaN()) {
                throw new SimRuntimeException("cannot schedule event " + event.toString() + " in past " + this.simulatorTime + ">" + event.getAbsoluteExecutionTime());
            }
            this.eventList.add(event);
            Logger.finest((Object)this, (String)"scheduleEvent", (String)("scheduled event at " + event.getAbsoluteExecutionTime()));
        }
    }

    public void scheduleEvent(double relativeDelay, Object source, Object target, String method, Object[] args) throws SimRuntimeException {
        this.scheduleEvent(relativeDelay, (short)5, source, target, method, args);
    }

    public void scheduleEvent(double relativeDelay, short priority, Object source, Object target, String method, Object[] args) throws SimRuntimeException {
        this.scheduleEvent(new SimEvent(this.simulatorTime + relativeDelay, priority, source, target, method, args));
    }

    public void scheduleEvent(double relativeDelay, TimeUnitInterface timeUnit, Object source, Object target, String method, Object[] args) throws RemoteException, SimRuntimeException {
        this.scheduleEvent(TimeUnit.convert(relativeDelay, timeUnit, this), (short)5, source, target, method, args);
    }

    public void scheduleEvent(double relativeDelay, TimeUnitInterface timeUnit, short priority, Object source, Object target, String method, Object[] args) throws RemoteException, SimRuntimeException {
        this.scheduleEvent(TimeUnit.convert(relativeDelay, timeUnit, this), priority, source, target, method, args);
    }

    public synchronized void setEventList(EventListInterface eventList) {
        this.eventList = eventList;
        Logger.finer((Object)this, (String)"setEventList", (String)("set the eventList to " + eventList.toString()));
        this.fireEvent(DEVSSimulatorInterface.EVENTLIST_CHANGED_EVENT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step() throws SimRuntimeException {
        Object object = this.semaphore;
        synchronized (object) {
            super.step();
            if (!this.eventList.isEmpty()) {
                this.running = true;
                SimEventInterface event = this.eventList.removeFirst();
                this.simulatorTime = event.getAbsoluteExecutionTime();
                this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
                event.execute();
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning()) {
            Object object = this.semaphore;
            synchronized (object) {
                SimEventInterface event = this.eventList.removeFirst();
                this.simulatorTime = event.getAbsoluteExecutionTime();
                this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
                try {
                    event.execute();
                }
                catch (Exception exception) {
                    Logger.severe((Object)this, (String)"run", (Throwable)exception);
                }
            }
        }
    }

    public void stop() {
        super.stop();
        if (this.getReplication() != null && this.simulatorTime >= this.getReplication().getRunControl().getRunLength()) {
            this.eventList.clear();
        }
        if (this.eventList.isEmpty()) {
            this.fireEvent((EventInterface)new Event(SimulatorInterface.END_OF_REPLICATION_EVENT, (Object)this, null));
        }
    }
}

