/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.simulators;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.language.concurrent.WorkerThread;
import nl.tudelft.simulation.logger.Logger;

public abstract class Simulator
extends EventProducer
implements SimulatorInterface,
Runnable {
    protected double simulatorTime = Double.NaN;
    protected boolean running = false;
    protected Replication replication = null;
    protected WorkerThread worker = null;
    protected Object semaphore = new Object();
    static /* synthetic */ Class class$nl$tudelft$simulation$jstats$statistics$StatisticsObject;

    public Simulator() {
        this.worker = new WorkerThread(this.getClass().getName(), (Runnable)this);
    }

    public double getSimulatorTime() {
        return this.simulatorTime;
    }

    public Replication getReplication() {
        return this.replication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Replication replication) throws RemoteException, SimRuntimeException {
        if (replication == null) {
            throw new IllegalArgumentException("replication == null ?");
        }
        if (this.isRunning()) {
            throw new SimRuntimeException("Cannot initialize a running simulator");
        }
        Object object = this.semaphore;
        synchronized (object) {
            this.removeAllListeners(class$nl$tudelft$simulation$jstats$statistics$StatisticsObject == null ? (class$nl$tudelft$simulation$jstats$statistics$StatisticsObject = Simulator.class$("nl.tudelft.simulation.jstats.statistics.StatisticsObject")) : class$nl$tudelft$simulation$jstats$statistics$StatisticsObject);
            this.replication = replication;
            this.simulatorTime = 0.0;
            this.fireEvent(SimulatorInterface.START_REPLICATION_EVENT, null, this.getSimulatorTime());
            this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
            Logger.finer((Object)this, (String)"initialize", (String)"OK");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SimRuntimeException, RemoteException {
        if (this.isRunning()) {
            throw new SimRuntimeException("Cannot start a running simulator");
        }
        if (this.replication == null) {
            throw new SimRuntimeException("Cannot start a simulator without replication details");
        }
        if (this.simulatorTime >= this.replication.getRunControl().getRunLength()) {
            throw new SimRuntimeException("Cannot start simulator : simulatorTime = runLength");
        }
        Object object = this.semaphore;
        synchronized (object) {
            this.running = true;
            this.fireEvent(SimulatorInterface.START_EVENT, null);
            this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
            Logger.finer((Object)this, (String)"start", (String)"OK");
            if (!Thread.currentThread().getName().equals(this.worker.getName())) {
                this.worker.interrupt();
            } else {
                this.run();
            }
        }
    }

    public void step() throws SimRuntimeException {
        if (this.isRunning()) {
            throw new SimRuntimeException("Cannot step a running simulator");
        }
        if (this.replication == null) {
            throw new SimRuntimeException("Cannot step a simulator without replication details");
        }
        if (this.simulatorTime >= this.replication.getRunControl().getRunLength()) {
            throw new SimRuntimeException("Cannot step simulator: SimulatorTime = runControl.runLength");
        }
        Logger.finer((Object)this, (String)"step", (String)"OK");
        this.fireEvent(SimulatorInterface.STEP_EVENT, null);
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            Logger.finer((Object)this, (String)"stop", (String)"OK");
            if (this.simulatorTime >= this.getReplication().getRunControl().getRunLength()) {
                this.fireEvent((EventInterface)new Event(SimulatorInterface.END_OF_REPLICATION_EVENT, (Object)this, null));
            }
            this.fireEvent(SimulatorInterface.STOP_EVENT, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

