/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.statistics;

import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import nl.tudelft.simulation.dsol.context.ContextUtil;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.statistics.Tally;
import nl.tudelft.simulation.logger.Logger;

public class Persistent
extends nl.tudelft.simulation.jstats.statistics.Persistent {
    private SimulatorInterface simulator = null;
    private boolean stopped = false;

    public Persistent(String description, SimulatorInterface simulator) throws RemoteException {
        super(description);
        this.simulator = simulator;
        if (this.simulator.getSimulatorTime() > this.simulator.getReplication().getRunControl().getWarmupPeriod()) {
            this.initialize();
        } else {
            this.simulator.addListener((EventListenerInterface)this, SimulatorInterface.WARMUP_EVENT, (short)0, false);
        }
        this.simulator.addListener((EventListenerInterface)this, SimulatorInterface.END_OF_REPLICATION_EVENT, (short)0, false);
        ContextUtil.bindToContext(simulator, (Object)this);
    }

    public Persistent(String description, SimulatorInterface simulator, EventProducerInterface target, EventType field) throws RemoteException {
        this(description, simulator);
        target.addListener((EventListenerInterface)this, field, false);
    }

    public void notify(EventInterface event) {
        if (this.stopped) {
            return;
        }
        try {
            if (event.getSource().equals(this.simulator)) {
                if (event.getType().equals((Object)SimulatorInterface.WARMUP_EVENT)) {
                    this.simulator.removeListener((EventListenerInterface)this, SimulatorInterface.WARMUP_EVENT);
                    super.initialize();
                    return;
                }
                if (event.getType().equals((Object)SimulatorInterface.END_OF_REPLICATION_EVENT)) {
                    this.stopped = true;
                    this.simulator.removeListener((EventListenerInterface)this, SimulatorInterface.END_OF_REPLICATION_EVENT);
                    this.endOfReplication();
                    return;
                }
            } else if (this.isInitialized()) {
                super.notify(event);
            }
        }
        catch (RemoteException remoteException) {
            Logger.warning((Object)((Object)this), (String)"notify", (Throwable)remoteException);
        }
    }

    protected void endOfReplication() {
        try {
            String[] parts = nl.tudelft.simulation.naming.context.ContextUtil.resolveKey((Object)((Object)this)).split("/");
            String key = "";
            for (int i = 0; i < parts.length; ++i) {
                if (i == parts.length - 2) continue;
                key = key + parts[i] + "/";
            }
            key = key.substring(0, key.length() - 1);
            Tally tally = null;
            try {
                tally = (Tally)new InitialContext().lookup(key);
            }
            catch (NamingException exception) {
                tally = new Tally(((Tally)this).description);
                new InitialContext().bind(key, (Object)tally);
                tally.initialize();
            }
            tally.notify((EventInterface)new Event(null, (Object)this, (Object)new Double(((Tally)this).sampleMean)));
        }
        catch (Exception exception) {
            Logger.warning((Object)((Object)this), (String)"endOfReplication", (Throwable)exception);
        }
    }
}

