/*
 * @(#) StaticLocation.java Mar 4, 2004 Copyright (c) 2002-2005 Delft University
 * of Technology Jaffalaan 5, 2628 BX Delft, the Netherlands. All rights
 * reserved. This software is proprietary information of Delft University of
 * Technology The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.animation;

import java.awt.geom.Point2D;

import javax.media.j3d.Bounds;

import nl.tudelft.simulation.language.d3.DirectedPoint;

/**
 * A StaticLocation <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision: 1.6 $ $Date: 2005/07/04 12:23:52 $
 * @author <a href="http://www.peter-jacobs.com">Peter Jacobs </a>
 */
public class StaticLocation extends DirectedPoint implements LocatableInterface
{

    /**
     * the bounds
     */
    protected Bounds bounds = null;

    /**
     * constructs a new StaticLocation
     * 
     * @param x the x location
     * @param y the y location
     * @param z the z location
     * @param theta theta
     * @param phi phi
     * @param rho rho
     * @param bounds the bounds
     */
    public StaticLocation(final double x, final double y, final double z,
            final double theta, final double phi, final double rho,
            final Bounds bounds)
    {
        super(x, y, z, theta, phi, rho);
        this.bounds = bounds;
    }

    /**
     * constructs a new StaticLocation
     * 
     * @param point2D the point2d
     * @param rotZ the rotation in the xy plane
     * @param bounds the bounds
     */
    public StaticLocation(final Point2D point2D, final double rotZ,
            final Bounds bounds)
    {
        super(point2D, rotZ);
        this.bounds = bounds;
    }

    /**
     * constructs a new StaticLocation
     * 
     * @param location the location
     * @param bounds the bounds
     */
    public StaticLocation(final DirectedPoint location, final Bounds bounds)
    {
        super(location);
        this.bounds = bounds;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface
     *      #getLocation()
     */
    public DirectedPoint getLocation()
    {
        return this;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface #getBounds()
     */
    public Bounds getBounds()
    {
        return this.bounds;
    }

}