/*
 * @(#)Duplicate.java Feb 1, 2003 Copyright (c) 2002-2005 Delft University of
 * Technology Jaffalaan 5, 2628 BX Delft, the Netherlands. All rights reserved.
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.formalisms.flow;

import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * A duplicate station duplicates incoming objects and sends them to their
 * alternative destination. <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision: 1.8 $ $Date: 2005/08/04 12:09:28 $
 * @author <a href="http://www.peter-jacobs.com/index.htm">Peter Jacobs </a>, <a
 *         href="mailto:a.verbraeck@tbm.tudelft.nl">Alexander
 *         Verbraeck </a>
 */
public class Duplicate extends Station
{

    /**
     * duplicateDestination which is the duplicate definition
     */
    private StationInterface duplicateDestination;

    /** numberCopies refers to the number of duplicates */
    private int numberCopies;

    /**
     * Method Duplicate. Creates a new Duplicate
     * 
     * @param simulator on which is scheduled
     * @param duplicateDestination the duplicate destination
     */
    public Duplicate(final DEVSSimulatorInterface simulator,
            final StationInterface duplicateDestination)
    {
        this(simulator, duplicateDestination, 1);
    }

    /**
     * Method Duplicate.
     * 
     * @param simulator on which is scheduled
     * @param duplicateDestination which is the duplicate definition
     * @param numberCopies the number of copies
     */
    public Duplicate(final DEVSSimulatorInterface simulator,
            final StationInterface duplicateDestination, final int numberCopies)
    {
        super(simulator);
        this.duplicateDestination = duplicateDestination;
        this.numberCopies = numberCopies;
    }

    /**
     * @see StationInterface#receiveObject(Object)
     */
    @Override
	public synchronized void receiveObject(final Object object)
            throws RemoteException
    {
        super.receiveObject(object);
        try
        {
            this.releaseObject(object);
            if (object instanceof Serializable)
            {
                for (int i = 0; i < this.numberCopies; i++)
                {
                    Object clone = new MarshalledObject(object).get();
                    this.fireEvent(StationInterface.RELEASE_EVENT, 1);
                    this.duplicateDestination.receiveObject(clone);
                }
            } else
            {
                throw new Exception("cannot duplicate object: "
                        + object.getClass()
                        + " does not implement java.io.Serializable");
            }
        } catch (Exception exception)
        {
            Logger.warning(this, "receiveMethod", exception);
        }
    }
}