/*
 * @(#)DEVDESSSimulatorInterface.java Aug 18, 2003 Copyright (c) 2002-2005 Delft
 * University of Technology Jaffalaan 5, 2628 BX Delft, the Netherlands. All
 * rights reserved. This software is proprietary information of Delft University
 * of Technology The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.simulators;

/**
 * The DEVSDESS simulator embodies both the continuous and the discrete
 * formalism. This simulator takes pre-defined time steps in between it loops
 * over its eventlist. A better name for this formalism would therefore be the
 * DEVSinDESS formalism. More information on Modeling & Simulation can be found
 * in Theory of Modeling and Simulation by Bernard Zeigler et. al.
 * <p>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @author <a href="http://www.peter-jacobs.com">Peter Jacobs </a>
 * @version $Revision: 1.6 $ $Date: 2005/07/04 12:23:53 $
 * @since 1.5
 */
public interface DEVDESSSimulatorInterface extends DEVSSimulatorInterface,
        DESSSimulatorInterface
{
    // This interface combines the DESS and DEVS interfaces and does not add
    // any operations.
}