/*
 * @(#) Histogram.java Oct 19, 2003 Copyright (c) 2002-2005 Delft University of
 * Technology Jaffalaan 5, 2628 BX Delft, the Netherlands. All rights reserved.
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.statistics.charts;

import java.rmi.RemoteException;

import javax.naming.Context;

import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.context.ContextUtil;

/**
 * The Histogram extends the Histogram and links this it to the dsol framework
 * <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision: 1.7 $ $Date: 2005/08/04 12:09:24 $
 * @author <a href="http://www.peter-jacobs.com">Peter Jacobs </a>
 */
public class Histogram extends
        nl.tudelft.simulation.jstats.charts.histogram.Histogram
{

    /**
     * constructs a new Histogram
     * 
     * @param simulator the simulator
     * @param title the title of the plot
     * @param domain the domain of the plot
     * @param range the range of the plot
     * @param numberofBins the number of bins in this plot
     */
    public Histogram(final SimulatorInterface simulator, final String title,
            final double[] domain, final double[] range, final int numberofBins)
    {
        super(title, domain, range, numberofBins);
        try
        {
            Context context = ContextUtil.lookup(simulator.getReplication()
                    .getContext(), "/charts");
            ContextUtil.bind(context, this);
        } catch (RemoteException exception)
        {
            Logger.warning(this, "<init>", exception);
        }
    }

    /**
     * constructs a new Histogram
     * 
     * @param simulator the simulator
     * @param title the title
     * @param domain the domain
     * @param numberofBins the number of bins
     */
    public Histogram(final SimulatorInterface simulator, final String title,
            final double[] domain, final int numberofBins)
    {
        super(title, domain, numberofBins);
        try
        {
            Context context = ContextUtil.lookup(simulator.getReplication()
                    .getContext(), "/charts");
            ContextUtil.bind(context, this);
        } catch (RemoteException exception)
        {
            Logger.warning(this, "<init>", exception);
        }
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return super.getChart().getTitle().getText();
    }
}