/*
 * AbstractBehaviour.java - created Feb 18, 2005 Copyright (C) 2005 TBA
 * Nederland Vulcanusweg 259, 2624 AV Delft, the Netherlands All rights
 * reserved.
 */

package nl.tudelft.simulation.dsol.formalisms.process;

import nl.tudelft.simulation.dsol.simulators.DEVSSimulator;
import nl.tudelft.simulation.dsol.simulators.Simulator;

/**
 * An abstract order
 * 
 * @author peter
 */
public class AbstractOrder extends Process
{
    /** our BWM */
    String car1 = "bmw";

    /** our second car */
    String car2 = null;

    /**
     * The abstract order
     * 
     * @param car the cae
     * @param scheduledTime the scheduled time
     * @param simulator the simulator to schedule on
     */
    public AbstractOrder(final String car, final double scheduledTime,
            final Simulator simulator)
    {
        super((DEVSSimulator) simulator);
        this.car2 = car;
    }

    /**
     * the process method
     */
    @Override
    public void process()
    {
        System.out.println("Print the cars");
        System.out.println("car1 =" + this.car1);
        System.out.println("car2 =" + this.car2);
    }
}