/*
 * @(#) UIInitializer.java Nov 19, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui;

import java.awt.Color;
import java.util.Enumeration;

import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

/**
 * A UIInitializer <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Nov 19, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public final class UIInitializer
{
	/**
	 * constructs a new UIInitializer (unreachable code)
	 */
	private UIInitializer()
	{
		// unreachable code
	}

	/**
	 * initializes the uiManager
	 */
	public static void initialize()
	{
		final Color backgroundColor = new Color(244, 244, 244);
		final Color menuColor = Color.WHITE;

		UIManager
				.put("Button.background", new ColorUIResource(backgroundColor));
		UIManager.put("CheckBox.background", backgroundColor);
		UIManager.put("CheckBox.border", BorderFactory.createEmptyBorder());
		UIManager.put("ComboBox.background", new ColorUIResource(
				backgroundColor));
		UIManager.put("ComboBox.selectionBackground", new ColorUIResource(
				backgroundColor));
		UIManager.put("EditorPane.background", new ColorUIResource(
				backgroundColor));
		UIManager.put("Label.background", new ColorUIResource(backgroundColor));
		UIManager.put("MenuBar.background", new ColorUIResource(menuColor));
		UIManager.put("MenuItem.background", new ColorUIResource(menuColor));
		UIManager.put("OptionPane.background", new ColorUIResource(
				backgroundColor));
		UIManager.put("Panel.background", new ColorUIResource(backgroundColor));
		UIManager
				.put("Slider.background", new ColorUIResource(backgroundColor));
		UIManager.put("Table.background", new ColorUIResource(backgroundColor));
		UIManager.put("Table.background", new ColorUIResource(backgroundColor));
		UIManager.put("TextField.border", BorderFactory.createEmptyBorder());
		UIManager.put("TextArea.Background", new ColorUIResource(
				backgroundColor));
		UIManager.put("TextField.inactiveBackground", new ColorUIResource(
				backgroundColor));
		UIManager.put("TextField.background", new ColorUIResource(
				backgroundColor));
		UIManager.put("TextField.selectionBackground", new ColorUIResource(
				backgroundColor));
		UIManager.put("Tree.background", new ColorUIResource(backgroundColor));
		UIManager.put("Tree.textBackground", new ColorUIResource(
				backgroundColor));

	}

	/**
	 * shows all parameters of the current uimanager
	 * 
	 * @param args the command-line arguments
	 */
	public static void main(final String[] args)
	{
		UIDefaults defaults = UIManager.getDefaults();
		Enumeration keys = defaults.keys();
		while (keys.hasMoreElements())
		{
			Object next = keys.nextElement();
			System.out.println(next + "  == " + defaults.get(next));
		}
	}
}