/*
 * Created on 8-okt-2003
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.rmi.RemoteException;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The SmoothWorker <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="mailto:nlang@fbk.eur.nl">Niels Lang </a>, <a
 *         href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class PauseAction extends SimulatorAction
{
	/**
	 * The pauseAction schedules a pause
	 * 
	 * @param application the application
	 */
	public PauseAction(final DSOLApplicationInterface application)
	{
		super("Pause Simulator At...", application);
		this.putValue(Action.MNEMONIC_KEY, new Integer('s'));
		this.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke('P',
				InputEvent.ALT_DOWN_MASK));
		this.putValue(Action.SMALL_ICON, new ImageIcon(this.getClass()
				.getResource("/toolbarButtonGraphics/media/Pause16.gif")));
	}

	/**
	 * notifyPaused
	 */
	protected void notifyStopped()
	{
		try
		{
			this.simulator.stop();
			JOptionPane
					.showMessageDialog(null, "Pausing simulation @ "
							+ this.simulator.getSimulatorTime()
							+ " on user's request.");
		} catch (Exception exception)
		{
			Logger.warning(this, "notifyStopped", exception);
		}
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent evt)
	{
		String result = JOptionPane.showInputDialog("Enter desired pause-time");
		if (result != null)
		{
			try
			{
				double value = Double.parseDouble(result);
				if (value > this.simulator.getSimulatorTime()
						|| (new Double(this.simulator.getSimulatorTime())
								.isNaN() && value >= 0.0))
				{
					((DEVSSimulatorInterface) this.simulator)
							.scheduleEvent(new SimEvent(value,
									SimEventInterface.MIN_PRIORITY, this, this,
									"notifyStopped", null));
					JOptionPane.showMessageDialog(null,
							"Succesfully scheduled pause @ " + value);
				} else
				{
					throw new Exception();
				}
			} catch (Exception exception)
			{
				try
				{
					JOptionPane.showMessageDialog(null, "Invalid input: "
							+ result
							+ ". Value should be numerical and larger than "
							+ "simulator time:"
							+ this.simulator.getSimulatorTime());
				} catch (RemoteException remoteException)
				{
					Logger.warning(this, "actionPerformed", remoteException);
				}
			}
		}
	}
}