/*
 * @(#) Renderable2DComparator.java Apr 28, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.animation2D;

import java.util.Comparator;

import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Apr 28, 2004
 * @since 1.4
 */
public class Renderable2DComparator implements Comparator
{

	/**
	 * constructs a new Renderable2DComparator
	 */
	public Renderable2DComparator()
	{
		super();
	}

	/**
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(final Object o1, final Object o2)
	{
		try
		{
			Renderable2DInterface r1 = (Renderable2DInterface) o1;
			Renderable2DInterface r2 = (Renderable2DInterface) o2;
			if (r1.getSource().getLocation().z > r2.getSource().getLocation().z)
			{
				return 1;
			}
			if (r1.getSource().getLocation().z < r2.getSource().getLocation().z)
			{
				return -1;
			}

		} catch (Exception exception)
		{
			Logger.warning(this, "compare", exception);
		}
		return new Integer(o1.hashCode()).compareTo(new Integer(o2.hashCode()));
	}
}