/*
 * @(#) PanLeftAction.java Oct 29, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.animation2D.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

import nl.tudelft.simulation.dsol.gui.animation2D.GridPanel;
import nl.tudelft.simulation.language.io.URLResource;

/**
 * The PanLeftAction.java (c) copyright 2003 <a
 * href="http://www.simulation.tudelft.nl">Delft University of Technology </a>,
 * the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="mailto:nlang@fbk.eur.nl">Niels Lang </a>, <a
 *         href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class PanLeftAction extends AbstractAction
{
	/** target of the gridpanel */
	private GridPanel target = null;

	/**
	 * constructs a new ZoomIn
	 * 
	 * @param target the target
	 */
	public PanLeftAction(final GridPanel target)
	{
		super("PanLeft");
		this.target = target;
		this.putValue(Action.SMALL_ICON, new ImageIcon(URLResource
				.getResource("/toolbarButtonGraphics/navigation/Back16.gif")));
		this.setEnabled(true);
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent actionEvent)
	{
		this.target.pan(GridPanel.LEFT, 0.1);
		this.target.requestFocus();
	}
}