/*
 * @(#) ViewBranch.java May 10, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.animation3D;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

import nl.tudelft.simulation.dsol.gui.animation3D.mouse.RotateXYMouseBehavior;
import nl.tudelft.simulation.dsol.gui.animation3D.mouse.TranslateMouseBehavior;
import nl.tudelft.simulation.dsol.gui.animation3D.mouse.ZoomMouseBehavior;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;

/**
 * ViewBranch, the view platform of the scene graph <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 10.05.2004 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class ViewBranch extends BranchGroup
{
	/** Rotate around X-axis */
	protected Transform3D rotateX = new Transform3D();

	/** Rotate around Y-axis */
	protected Transform3D rotateY = new Transform3D();

	/** Zoom */
	protected Transform3D zoom = new Transform3D();

	/** Translation */
	protected Transform3D translation = new Transform3D();

	/** Rotation around the y-axis of view platform */
	protected TransformGroup rotateYGroup;

	/** Rotation around the x-axis of view platform */
	protected TransformGroup rotateXGroup;

	/** Zoom of view platform */
	protected TransformGroup zoomGroup;

	/** Translation of view platform */
	protected TransformGroup translateGroup;

	/**
	 * Constructs the view branch
	 * 
	 * @param canvas3D A canvas3D
	 */
	public ViewBranch(final Canvas3D canvas3D)
	{
		super();
		createBranch(canvas3D);
	}

	/**
	 * Create the view branch
	 * 
	 * @param canvas3D A canvas3D
	 */
	protected void createBranch(final Canvas3D canvas3D)
	{
		// Transformation of the view
		this.rotateX.set(new Vector3f(0.0f, 0.0f, 0.0f));
		this.rotateY.set(new Vector3f(0.0f, 0.0f, 0.0f));
		this.zoom.set(new Vector3f(0.0f, 0.0f, 10.0f));
		this.translation.set(new Vector3f(0.0f, 1.0f, 0.0f));

		// Parent of view platform elements
		this.rotateYGroup = new TransformGroup(this.rotateY);
		this.rotateXGroup = new TransformGroup(this.rotateX);
		this.zoomGroup = new TransformGroup(this.zoom);
		this.translateGroup = new TransformGroup(this.translation);

		// Allow read write
		this.rotateYGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.rotateYGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.rotateXGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.rotateXGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.zoomGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.zoomGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.translateGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.translateGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

		// The view platform
		ViewPlatform viewPlatform = new ViewPlatform();

		// Mouse
		RotateXYMouseBehavior mouseRotate = new RotateXYMouseBehavior(
				MouseBehavior.INVERT_INPUT);
		mouseRotate.setTransformGroup(this.rotateYGroup);
		mouseRotate.setTransformGroupX(this.rotateXGroup);
		mouseRotate.setFactor(0.1);
		this.rotateYGroup.addChild(mouseRotate);
		BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0),
				1000.0);
		mouseRotate.setSchedulingBounds(bounds);

		ZoomMouseBehavior mouseZoom = new ZoomMouseBehavior(canvas3D,
				MouseBehavior.INVERT_INPUT);
		//mouseZoom.setTransformGroup(this.zoomGroup);
		mouseZoom.setTransformGroup(this.translateGroup);
		mouseZoom.setSchedulingBounds(bounds);
		mouseZoom.setRotateXGroup(this.rotateXGroup);
		mouseZoom.setRotateYGroup(this.rotateYGroup);
		this.zoomGroup.addChild(mouseZoom);

		TranslateMouseBehavior mouseTranslate = new TranslateMouseBehavior(canvas3D,
				MouseBehavior.INVERT_INPUT);
		mouseTranslate.setTransformGroup(this.translateGroup);
		mouseTranslate.setSchedulingBounds(bounds);
		mouseTranslate.setRotateXGroup(this.rotateXGroup);
		mouseTranslate.setRotateYGroup(this.rotateYGroup);
		this.translateGroup.addChild(mouseTranslate);

		// Create physical elements: the viewer himself
		PhysicalBody body = new PhysicalBody();
		PhysicalEnvironment environment = new PhysicalEnvironment();

		// Put it all together
		/*
		this.rotateYGroup.addChild(this.rotateXGroup);
		this.rotateXGroup.addChild(this.zoomGroup);
		this.zoomGroup.addChild(this.translateGroup);
		this.translateGroup.addChild(viewPlatform);
		this.addChild(this.rotateYGroup);
		*/
		
		this.translateGroup.addChild(this.rotateYGroup);
		this.rotateYGroup.addChild(this.rotateXGroup);
		this.rotateXGroup.addChild(this.zoomGroup);
		this.zoomGroup.addChild(viewPlatform);	
		this.addChild(this.translateGroup);
		
		View view = new View();
		// Set back clip distance to 5000 meters for the
		// time being.
		view.setBackClipDistance(5000);
		view.addCanvas3D(canvas3D);
		view.attachViewPlatform(viewPlatform);
		view.setPhysicalBody(body);
		view.setPhysicalEnvironment(environment);
	}

	/**
	 * Reset the view to the original setting
	 */
	public void resetView()
	{
		this.rotateYGroup.setTransform(this.rotateY);
		this.rotateXGroup.setTransform(this.rotateX);
		this.zoomGroup.setTransform(this.zoom);
		this.translateGroup.setTransform(this.translation);
	}

	/**
	 * @return RotateX
	 */
	public Transform3D getRotateX()
	{
		return this.rotateX;
	}

	/**
	 * @return RotateY
	 */
	public Transform3D getRotateY()
	{
		return this.rotateY;
	}

	/**
	 * @return Translation
	 */
	public Transform3D getTranslation()
	{
		return this.translation;
	}

	/**
	 * @return Zoom
	 */
	public Transform3D getZoom()
	{
		return this.zoom;
	}

	/**
	 * @param rotateX Rotation around X-axis
	 */
	public void setRotateX(final Transform3D rotateX)
	{
		this.rotateX = rotateX;
		this.rotateXGroup.setTransform(rotateX);
	}

	/**
	 * @param rotateY Rotation around Y-axis
	 */
	public void setRotateY(final Transform3D rotateY)
	{
		this.rotateY = rotateY;
		this.rotateYGroup.setTransform(rotateY);
	}

	/**
	 * @param translation Translation
	 */
	public void setTranslation(final Transform3D translation)
	{
		this.translation = translation;
		this.translateGroup.setTransform(translation);
	}

	/**
	 * @param zoom Zoom factor
	 */
	public void setZoom(final Transform3D zoom)
	{
		this.zoom = zoom;
		this.zoomGroup.setTransform(zoom);
	}

}