/*
 * @(#) EditMenu.java 25-jul-2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

import nl.tudelft.simulation.dsol.gui.editor2D.actions.EditMenuActions;


/**
 * EditMenu.java <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class EditMenu extends JMenu
{
    /** the editor2d panel */
    private Editor2DPanel panel = null;
    
	/** move the obejct option */
	private JRadioButtonMenuItem moveItem = null;

	/** rotate the object option */
	private JRadioButtonMenuItem rotateItem = null;

	/** add point option */
	private JMenuItem addPointItem = null;

	/** actions */
	private EditMenuActions actions = null;

	/**
	 * Constructor
	 * 
	 * @param text The title of this menu
	 * @param panel The Editor2DPanel
	 */
	public EditMenu(final String text, final Editor2DPanel panel)
	{
		super();
		this.setText(text);
		this.actions = new EditMenuActions(this, panel);
		this.panel = panel;
		this.initialize();
	}

	/**
	 * Initialize menu
	 */
	private void initialize()
	{
		// Move
		this.moveItem = new JRadioButtonMenuItem("Move");
		this.moveItem.addActionListener(this.actions);
		this.moveItem.setSelected(true);
		panel.setSelectedEditMode(Editor2DPanel.EDIT_MODE_MOVE);

		// Rotate
		this.rotateItem = new JRadioButtonMenuItem("Rotate");
		this.rotateItem.addActionListener(this.actions);

		// Add point
		this.addPointItem = new JMenuItem("Add point");
		this.addPointItem.addActionListener(this.actions);

		// Construct menu
		ButtonGroup group = new ButtonGroup();
		group.add(this.moveItem);
		group.add(this.rotateItem);
		this.add(this.moveItem);
		this.add(this.rotateItem);
		this.add(new JSeparator());
		this.add(this.addPointItem);
	}

	/**
	 * @return Returns the moveItem.
	 */
	public JRadioButtonMenuItem getMoveItem()
	{
		return this.moveItem;
	}

	/**
	 * @return Returns the rotateItem.
	 */
	public JRadioButtonMenuItem getRotateItem()
	{
		return this.rotateItem;
	}

	/**
	 * @return Returns the addPointItem.
	 */
	public JMenuItem getAddPointItem()
	{
		return this.addPointItem;
	}
}