/*
 * @(#) NavigationToolbarActions.java 20-jul-2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import nl.tudelft.simulation.dsol.gui.animation2D.GridPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.NavigationToolbar;


/**
 * NavigationToolbarActions.java <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class NavigationToolbarActions implements ActionListener
{

	/** Parent of actions */
	private NavigationToolbar source = null;

	/** target of the gridpanel */
	private GridPanel target = null;

	/**
	 * Constructor
	 * 
	 * @param source Source panel
	 * @param target Target grid panel
	 */
	public NavigationToolbarActions(final NavigationToolbar source,
			final GridPanel target)
	{
		super();
		this.source = source;
		this.target = target;
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		Object src = event.getSource();

		if (src.equals(this.source.getPanLeft()))
		{
			this.target.pan(GridPanel.LEFT, 0.01);
		} else if (src.equals(this.source.getPanRight()))
		{
			this.target.pan(GridPanel.RIGHT, 0.01);
		} else if (src.equals(this.source.getPanUp()))
		{
			this.target.pan(GridPanel.UP, 0.01);
		} else if (src.equals(this.source.getPanDown()))
		{
			this.target.pan(GridPanel.DOWN, 0.01);
		} else if (src.equals(this.source.getZoomIn()))
		{
			this.target.zoom(GridPanel.IN, 0.95);
		} else if (src.equals(this.source.getZoomOut()))
		{
			this.target.zoom(GridPanel.OUT, 0.95);
		} else if (src.equals(this.source.getHome()))
		{
			this.target.home();
		} else if (src.equals(this.source.getTroggleGrid()))
		{
			this.target.showGrid(!this.target.isShowGrid());
		}
	}

}