/*
 * @(#) FileMenu.java Nov 5, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu;

import java.rmi.RemoteException;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.menu.actions.CloseExperimentAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ExitAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.OpenFileAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.OpenRecentAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.OpenURLAction;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The File Menu <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class FileMenu extends JMenu implements EventListenerInterface
{
	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new FileMenu
	 * 
	 * @param application the application
	 */
	public FileMenu(final DSOLApplicationInterface application)
	{
		super("File");
		this.application = application;
		this.setMnemonic('F');
		try
		{
			this.application.addListener(this,
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
		} catch (RemoteException exception)
		{
			Logger.warning(this, "FileMenu", exception);
		}

		this.initialize();
	}

	/**
	 * initializes the menu
	 */
	private void initialize()
	{
		JMenuItem openFileItem = new JMenuItem(new OpenFileAction(
				this.application));
		this.add(openFileItem);

		JMenuItem openURLItem = new JMenuItem(new OpenURLAction(
				this.application));
		this.add(openURLItem);

		JMenuItem closeURLItem = new JMenuItem(new CloseExperimentAction(
				this.application));
		this.add(closeURLItem);

		this.add(new JSeparator());
		this.add(this.createRecent());
		this.add(new JSeparator());

		JMenuItem exitItem = new JMenuItem(new ExitAction(this.application));
		this.add(exitItem);
	}

	/**
	 * creates a recent menu
	 * 
	 * @return JMenu
	 */
	private JMenu createRecent()
	{
		JMenu recent = new JMenu("Open Recent");
		for (int i = 0; i < 3; i++)
		{
			String label = this.application.getProperties().getProperty(
					"recent[" + i + "]");
			if (label != null && label.length() > 0)
			{
				JMenuItem recentItem = new JMenuItem(new OpenRecentAction(
						this.application, label.split("!#!")[0]));
				recent.add(recentItem);
			}
		}
		return recent;
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		if (event.getSource().equals(this.application)
				&& event.getType().equals(
						DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT))
		{
			this.remove(4);
			this.add(this.createRecent(), 4);
		}
	}
}