/*
 * @(#) HelpMenu.java Nov 5, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.menu.actions.OpenRecentAction;

/**
 * The HelpMenu <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class HelpMenu extends JMenu
{
	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new FileMenu
	 * 
	 * @param application the application
	 */
	public HelpMenu(final DSOLApplicationInterface application)
	{
		super("Help");
		this.application = application;
		this.setMnemonic('H');
		this.initialize();
	}

	/**
	 * initializes the menu
	 */
	private void initialize()
	{
		JMenuItem welcomeItem = new JMenuItem("Welcome");
		welcomeItem.setMnemonic('W');
		welcomeItem.setEnabled(false);
		this.add(welcomeItem);

		JMenu tutorial = new JMenu("Tutorial");

		JMenuItem tutorial1 = new JMenuItem(
				new OpenRecentAction(this.application,
						"http://www.simulation.tudelft.nl/dsol/tutorial/160/section24.xml"));
		tutorial.add(tutorial1);

		JMenuItem tutorial2 = new JMenuItem(
				new OpenRecentAction(this.application,
						"http://www.simulation.tudelft.nl/dsol/tutorial/160/section41.xml"));
		tutorial.add(tutorial2);

		JMenuItem tutorial3 = new JMenuItem(
				new OpenRecentAction(this.application,
						"http://www.simulation.tudelft.nl/dsol/tutorial/160/section42.xml"));
		tutorial.add(tutorial3);

		JMenuItem tutorial4 = new JMenuItem(
				new OpenRecentAction(this.application,
						"http://www.simulation.tudelft.nl/dsol/tutorial/160/section43.xml"));
		tutorial.add(tutorial4);

		JMenuItem tutorial5 = new JMenuItem(
				new OpenRecentAction(this.application,
						"http://www.simulation.tudelft.nl/dsol/tutorial/160/section44.xml"));
		tutorial.add(tutorial5);
		
		JMenuItem tutorial6 = new JMenuItem(
				new OpenRecentAction(this.application,
						"http://www.simulation.tudelft.nl/dsol/tutorial/160/section45.xml"));
		tutorial.add(tutorial6);
		
		this.add(tutorial);

		this.add(new JSeparator());

		JMenuItem aboutItem = new JMenuItem("About DSOL");
		aboutItem.setMnemonic('A');
		aboutItem.setEnabled(false);
		this.add(aboutItem);
	}
}