/*
 * @(#) ToolsMenu.java Nov 5, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.actions.PauseAction;

/**
 * The ToolMenu <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class ToolsMenu extends JMenu
{
	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new FileMenu
	 * 
	 * @param application the application
	 */
	public ToolsMenu(final DSOLApplicationInterface application)
	{
		super("Tools");
		this.application = application;
		this.setMnemonic('T');
		this.initialize();
	}

	/**
	 * initializes the menu
	 */
	private void initialize()
	{
		JMenuItem pauseItem = new JMenuItem(new PauseAction(this.application));
		this.add(pauseItem);
	}
}